"""
/***************************************************************************
Name            :  help_controller.py
Description     :  A class for help icon
copyright       :  (C) 2019-2023 by FEWS
email           :  minxuansun@contractor.usgs.gov
Created         :  03/23/2020 Minxuan Sun
Modified        :  10/06/2022 - cholen - Update manual, add Spanish version
                   09/24/2025 - dhackman - Update logic for view_manual
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from PyQt5.QtWidgets import QAction, QMenu

from fews_tools.controllers.about_controller import AboutController

from fews_tools.utilities.help_utilities import view_manual

class HelpController:
    """
    Class GeoClIM Help Controller
    """

    def __init__(self, iface):
        """
        Constructor - Add menu to the Help icon
        """
        self.menu = QMenu()
        action_about = QAction('About', iface.mainWindow())
        action_about.triggered.connect(self.about)
        self.menu.addAction(action_about)

        action_view_english_geoclim_manual = QAction(
            'View GeoCLIM Manual', iface.mainWindow())
        action_view_english_geoclim_manual.triggered.connect(
            self.view_english_geoclim_manual)
        self.menu.addAction(action_view_english_geoclim_manual)

    @staticmethod
    def about():
        """
        Static method used to open GeoCLIM about form
        """
        about_dlg = AboutController()
        about_dlg.exec_()

    @staticmethod
    def view_english_geoclim_manual():
        """
        Static method used to open the English manual
        :return:
        """
        view_manual()

    def get_menu(self):
        """
        Menu getter
        """
        return self.menu
