"""
/***************************************************************************
Name            :  netCDF_controller.py
Description     :  A class to open external NetCDF to export bils to NetCDF
                   or convert NetCDF to bils
copyright       :  (C) 2019 - 2023 by FEWS
email           :  minxuansun@contractor.usgs.gov
Created         :  3/12/2020 Minxuan Sun
Modified        :  MM/DD/YYYY - <developer> - Description
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
# Import the PyQt and QGIS libraries
from PyQt5.QtWidgets import QMessageBox, QDialog, QFileDialog, QMenu, QAction

from qgis.utils import iface

import os
import subprocess

from fews_tools import fews_tools_config as config
from fews_tools.utilities import geoclim_utilities as util


class NetCDFController:
    def __init__(self, iface):
        """
        Constructor - Add menu to the NetCDF icon
        """
        self.menu = QMenu()
        action_export = \
            QAction(u'Export bils to netCDF', iface.mainWindow())
        action_convert = \
            QAction(u'Convert netCDF to bils', iface.mainWindow())
        action_export.triggered.connect(self.export)
        action_convert.triggered.connect(self.convert)
        self.menu.addAction(action_export)
        self.menu.addAction(action_convert)

    @staticmethod
    def export():
        """
        Static method used to call the bil to netcdf method in NetCDF
        :return:
        """
        netcdf_exe_path = \
            os.path.join(os.path.dirname(os.path.realpath(__file__)),
                         config.NET_CDF_DIR,
                         config.NET_CDF_EXE)
        cmd = \
            (util.handle_subprocess_call_path(netcdf_exe_path) + ' bil2netcdf')
        result = subprocess.call(cmd, shell=False)
        if result == -1:
            msg = u'Export failed'
            iface.mainWindow().statusBar().showMessage(msg)
            QMessageBox.information(None,
                                    msg,
                                    msg,
                                    QMessageBox.Ok)

    @staticmethod
    def convert():
        """
        Static method used to call the netcdf to bil method in NetCDF
        :return:
        """
        netcdf_exe_path = \
            os.path.join(os.path.dirname(os.path.realpath(__file__)),
                         config.NET_CDF_DIR,
                         config.NET_CDF_EXE)
        cmd = \
            (util.handle_subprocess_call_path(netcdf_exe_path) + ' netcdf2bil')
        result = subprocess.call(cmd, shell=False)
        if result == -1:
            msg = u'Export failed'
            iface.mainWindow().statusBar().showMessage(msg)
            QMessageBox.information(None,
                                    msg,
                                    msg,
                                    QMessageBox.Ok)

    def get_menu(self):
        return self.menu



