'''
/***************************************************************************
Name	   :  new_dataset_controller.py
Description:  New Dataset controller class for FEWSTools plugin
copyright  :  (C) 2020-2023 by FEWS
email      :  minxuansun@contractor.usgs.gov
created    :  02/13/2020
Modified   :  07/26/2022 - cholen - Codebase consistency changes
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
'''
import re

from PyQt5.QtWidgets import QMessageBox, QDialog

from fews_tools import fews_tools_config as config
from fews_tools.models.datasets_model import DatasetsModel
from fews_tools.forms.Ui_NewDataset import Ui_NewDataset


class NewDatasetController(QDialog):
    '''
    Class for new interpolated datasets controller
    collects a new name, type and extent for BASIICS created datasets
    other parameters are pulled from the BASIICS batch dictionary in the
    calling method
    '''
    def __init__(self):
        QDialog.__init__(self)
        self.ui = Ui_NewDataset()
        self.ui.setupUi(self)

        for dtype in config.DATA_TYPES:
            self.ui.dataTypeComboBox.addItem(dtype[0])
        for dext in config.DATA_EXTENTS:
            self.ui.dataExtentComboBox.addItem(dext)

        self.ui.dataTypeComboBox.setCurrentIndex(0)
        self.ui.dataExtentComboBox.setCurrentIndex(0)
        self.ui.lineEdit.setFocus()
        self.ui.okButton.clicked.connect(self.get_new_params)

    def validate_input(self):
        '''
        Validate the name entry
        '''
        err = False
        name_string = self.ui.lineEdit.text()
        if len(name_string) > config.MAX_CHARS or not\
                re.match(config.REG_EXPR_A, name_string):
            err = True
        if err is True:
            QMessageBox.critical(self,
                                 u'Error!! - Error in form',
                                 u'Error in name entry!',
                                 QMessageBox.Ok)
        return err

    def get_new_params(self):
        '''
        Get the widget values
        '''
        new_name = None
        data_type = None
        data_extent = None
        ds_model = DatasetsModel()
        err = self.validate_input()
        if not err:
            new_name = self.ui.lineEdit.text()
            err = ds_model.check_new_dataset_name(new_name)
        if not err:
            data_extent = self.ui.dataExtentComboBox.currentText()

            wid_val = self.ui.dataTypeComboBox.currentText()

            if wid_val == config.DATA_TYPES[0][0]:
                data_type = config.DATA_TYPES[0][1]
            elif wid_val == config.DATA_TYPES[1][0]:
                data_type = config.DATA_TYPES[1][1]
            elif wid_val == config.DATA_TYPES[2][0]:
                data_type = config.DATA_TYPES[2][1]
            elif wid_val == config.DATA_TYPES[3][0]:
                data_type = config.DATA_TYPES[3][1]
            else:  # 'PET':
                data_type = config.DATA_TYPES[4][1]

            self.close()
        return new_name, data_type, data_extent
