'''
/***************************************************************************
Name	   :  output_controller.py
Description:  Workspace Settings for FEWSTools plugin
copyright  :  (C) 2019-2023 by FEWS
email      :  minxuansun@contractor.usgs.gov
Modified   :  08/08/2022 - cholen - Disable ok if no selection

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
'''
from PyQt5 import QtCore
from PyQt5.QtWidgets import QDialog, QFileDialog

from fews_tools.utilities import database_utilities
from fews_tools.models.workspace_setup_model import WorkspaceSetupModel

from fews_tools.forms.Ui_OutputSettings import Ui_OutputSettings


class OutputController(QDialog):
    '''
    Class to handle the default output dir settings for FEWSTools plugin
    '''

    def __init__(self):
        QDialog.__init__(self)
        self.ui = Ui_OutputSettings()
        self.ui.setupUi(self)
        self.wrksp_setup = WorkspaceSetupModel()

        self.setup_table_name = 'WorkspaceSetup'
        self.default_output_dir = ''
        self.new_output_dir = ''

        # set up ui
        self.ui.outputDirLineEdit.setEnabled(False)
        self.get_default_output_dir()
        self.ui.defaultOutputDir.setText(self.default_output_dir[-60:])
        self.ui.browsePushButton.clicked.connect(self.browse_new_output_dir)
        self.ui.cancelPushButton.clicked.connect(self.close)
        self.ui.okPushButton.clicked.connect(self.set_new_output_dir)
        self.ui.okPushButton.setEnabled(False)

    def get_default_output_dir(self) -> None:
        '''
        Get default output directory path from database
        '''
        sql = 'SELECT OutputDir FROM ' + self.setup_table_name
        # this query will return a tuple, grab the 0 element for the string
        sql_result = database_utilities.query_db(sql)
        self.default_output_dir = sql_result[0]

    def browse_new_output_dir(self) -> None:
        '''
        Browse to desired location of output directory
        '''
        folder =\
            QFileDialog.getExistingDirectory(None,
                                             "Select output directory",
                                             QtCore.QDir.currentPath())
        self.new_output_dir = self.wrksp_setup.fix_os_sep_in_path(folder)
        self.ui.outputDirLineEdit.setText(self.new_output_dir[-60:])
        self.ui.okPushButton.setEnabled(True)

    def set_new_output_dir(self) -> None:
        '''
        Update database value based on selected new output directory
        '''
        if self.new_output_dir:
            sql = "UPDATE {} SET OutputDir='{}'".format(
                self.setup_table_name, self.new_output_dir)
            database_utilities.write_db(sql)
        self.close()
