"""
/***************************************************************************
Name            :  wrsi_help_controller.py
Description     :  A class for wrsi help icon
copyright       :  (C) 2022 - 2023 by FEWS
email           :  minxuansun@contractor.usgs.gov
Created         :  07/12/2022 Cheryl Holen
Modified        :  09/24/2025 - dhackman - Update logic for view_manual_wrsi
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from PyQt5.QtWidgets import QAction, QMenu

from fews_tools.utilities.help_utilities import view_manual_wrsi
from fews_tools.controllers.about_geowrsi_controller import AboutGeoWRSIController

class WRSIHelpController:
    """
    GeoWRSI help controller class.  Will not show version here.
    """

    def __init__(self, iface):
        """
        Constructor - Add menu to the Help icon
        """
        self.menu = QMenu()
        action_about = QAction('About', iface.mainWindow())
        action_about.triggered.connect(self.about)
        self.menu.addAction(action_about)

        action_view_english_geowrsi_manual = QAction(
            'View GeoWRSI Manual', iface.mainWindow())
        action_view_english_geowrsi_manual.triggered.connect(
            self.view_english_geowrsi_manual)
        self.menu.addAction(action_view_english_geowrsi_manual)

    @staticmethod
    def about():
        """
        Static method used to open GeoWRSI about form
        """
        about_dlg = AboutGeoWRSIController()
        about_dlg.exec_()

    @staticmethod
    def view_english_geowrsi_manual():
        """
        Static method used to open the English manual
        :return:
        """
        view_manual_wrsi()

    def get_menu(self):
        """
        Menu getter
        """
        return self.menu
