# -*- coding: utf-8 -*-
"""
Created on Mon Aug 22 15:39:09 2022

@author: cholen
"""
import os
from fews_tools import fews_tools_config as config
from fews_tools import database_utilities as db_util
DRIVE = "C:\\"  # example assumes Windows style paths
DATA_PATH = os.path.join(DRIVE, "temp", "GeoCLIM", "ProgramSettings", "Data")
STATIC_PATH = os.path.join(DATA_PATH, "Static")
MAP_PATH = os.path.join(DATA_PATH, "Maps")
COLOR_PATH = os.path.join(DRIVE, "temp", "GeoCLIM", "ProgramSettings", "Colors")
CELL_050 = 0.050
CELL_010 = 0.010
CELL_100 = 0.100
CELL_025 = 0.025

REGION_TABLE_VALUES = {
    "Africa": {
        "MinimumLatitude": -39.975,
        "MaximumLatitude": 39.975,
        "MinimumLongitude": -19.975,
        "MaximumLongitude": 54.975,
        "Height": CELL_050,
        "Width": CELL_050,
        "Mask": os.path.join(STATIC_PATH, "africa_chirps_mask.bil"),
        "Map": os.path.join(MAP_PATH, "af_adm1.shp"),
        "DefaultReg": "No",
        "Comments": None,
        "InitialPeriod": None,
        "FinalPeriod": None,
        "PeriodType": None,
        "SOS": None,
        "WRSI": None,
        "LGP": None,
        "WHC": None,
        "SOSColor": None},
    "Angola": {
        "MinimumLatitude": -18.7,
        "MaximumLatitude": -3.7,
        "MinimumLongitude": 11.1,
        "MaximumLongitude": 24.7,
        "Height": CELL_050,
        "Width": CELL_050,
        "Mask": os.path.join(STATIC_PATH, "ao_adm1_mask.bil"),
        "Map": os.path.join(MAP_PATH, "ao_adm3.shp"),
        "DefaultReg": "No",
        "Comments": "Angola Main Summer Season",
        "InitialPeriod": 25,
        "FinalPeriod": 15,
        "PeriodType": "Dekadal",
        "SOS": os.path.join(DATA_PATH, "Africa", "SOS", "sosmedn_edc_s.bil"),
        "WRSI": os.path.join(STATIC_PATH, "wsimedn_edc_s.bil"),
        "LGP": os.path.join(STATIC_PATH, "lgp_south.bil"),
        "WHC": os.path.join(STATIC_PATH, "whc3.bil"),
        "SOSColor": os.path.join(COLOR_PATH, "sos_sep_jan_dekads.qml")},
    "Benin": {
        "MinimumLatitude": 5.95,
        "MaximumLatitude": 12.75,
        "MinimumLongitude": 0.65,
        "MaximumLongitude": 4.0,
        "Height": CELL_050,
        "Width": CELL_050,
        "Mask": os.path.join(STATIC_PATH, "Benin_adm2_mask.bil"),
        "Map": os.path.join(MAP_PATH, "Benin_adm2.shp"),
        "DefaultReg": "No",
        "Comments": None,
        "InitialPeriod": None,
        "FinalPeriod": None,
        "PeriodType": None,
        "SOS": None,
        "WRSI": None,
        "LGP": None,
        "WHC": None,
        "SOSColor": None},
    "Botswana": {
        "MinimumLatitude": -27.4,
        "MaximumLatitude": -17.3,
        "MinimumLongitude": 19.5,
        "MaximumLongitude": 29.8,
        "Height": CELL_050,
        "Width": CELL_050,
        "Mask": os.path.join(STATIC_PATH, "bw_adm1_mask.bil"),
        "Map": os.path.join(MAP_PATH, "bw_adm2.shp"),
        "DefaultReg": "No",
        "Comments": "Botswana Main Summer Season",
        "InitialPeriod": 25,
        "FinalPeriod": 15,
        "PeriodType": "Dekadal",
        "SOS": os.path.join(DATA_PATH, "Africa", "SOS", "sosmedn_edc_s.bil"),
        "WRSI": os.path.join(STATIC_PATH, "wsimedn_edc_s.bil"),
        "LGP": os.path.join(STATIC_PATH, "lgp_south.bil"),
        "WHC": os.path.join(STATIC_PATH, "whc3.bil"),
        "SOSColor": os.path.join(COLOR_PATH, "sos_sep_jan_dekads.qml")},
    "Burkina Faso": {
        "MinimumLatitude": 9.125,
        "MaximumLatitude": 15.375,
        "MinimumLongitude": -5.875,
        "MaximumLongitude": 2.775,
        "Height": CELL_050,
        "Width": CELL_050,
        "Mask": os.path.join(STATIC_PATH, "BurkinaFaso_adm2_mask.bil"),
        "Map": os.path.join(MAP_PATH, "BurkinaFaso_adm2.shp"),
        "DefaultReg": "No",
        "Comments": None,
        "InitialPeriod": None,
        "FinalPeriod": None,
        "PeriodType": None,
        "SOS": None,
        "WRSI": None,
        "LGP": None,
        "WHC": None,
        "SOSColor": None},
    "Burundi": {
        "MinimumLatitude": -4.6,
        "MaximumLatitude": -2.2,
        "MinimumLongitude": 28.9,
        "MaximumLongitude": 31.0,
        "Height": CELL_010,
        "Width": CELL_010,
        "Mask": os.path.join(STATIC_PATH, "burundi_adm1_mask.bil"),
        "Map": os.path.join(MAP_PATH, "burundi_adm2.shp"),
        "DefaultReg": "No",
        "Comments": None,
        "InitialPeriod": None,
        "FinalPeriod": None,
        "PeriodType": None,
        "SOS": None,
        "WRSI": None,
        "LGP": None,
        "WHC": None,
        "SOSColor": None},
    "Cameroon": {
        "MinimumLatitude": 1.0,
        "MaximumLatitude": 13.7,
        "MinimumLongitude": 8.1,
        "MaximumLongitude": 16.6,
        "Height": CELL_050,
        "Width": CELL_050,
        "Mask": os.path.join(STATIC_PATH, "Cameroon_adm2_mask.bil"),
        "Map": os.path.join(MAP_PATH, "Cameroon_adm2.shp"),
        "DefaultReg": "No",
        "Comments": None,
        "InitialPeriod": None,
        "FinalPeriod": None,
        "PeriodType": None,
        "SOS": None,
        "WRSI": None,
        "LGP": None,
        "WHC": None,
        "SOSColor": None},
    "Central America": {
        "MinimumLatitude": 6.075,
        "MaximumLatitude": 23.475,
        "MinimumLongitude": -92.975,
        "MaximumLongitude": -57.025,
        "Height": CELL_050,
        "Width": CELL_050,
        "Mask": os.path.join(STATIC_PATH, "CentralAmerica.bil"),
        "Map": os.path.join(MAP_PATH, "world_adm0.shp"),
        "DefaultReg": "No",
        "Comments": None,
        "InitialPeriod": None,
        "FinalPeriod": None,
        "PeriodType": None,
        "SOS": None,
        "WRSI": None,
        "LGP": None,
        "WHC": None,
        "SOSColor": None},
    "Central America Apr-Sep": {
        "MinimumLatitude": 7.3,
        "MaximumLatitude": 21.5,
        "MinimumLongitude": -93.0,
        "MaximumLongitude": -93.0,
        "Height": CELL_050,
        "Width": CELL_050,
        "Mask": os.path.join(STATIC_PATH, "win_cena105.bil"),
        "Map": os.path.join(MAP_PATH, "Central_America.bna"),
        "DefaultReg": "No",
        "Comments": "Central America Season (Apr-Sep)",
        "InitialPeriod": 7,
        "FinalPeriod": 30,
        "PeriodType": "Dekadal",
        "SOS": os.path.join(DATA_PATH, "Central_America", "SOS", "soscena1lta.bil"),
        "WRSI": os.path.join(STATIC_PATH, "wrsicena1p5.bil"),
        "LGP": os.path.join(STATIC_PATH, "lgp_cena1p5.bil"),
        "WHC": os.path.join(STATIC_PATH, "whc_cena.bil"),
        "SOSColor": os.path.join(COLOR_PATH, "sos_apr_aug_dekads.qml")},
    "Central America Aug-Dec": {
        "MinimumLatitude": 7.3,
        "MaximumLatitude": 21.5,
        "MinimumLongitude": -93.0,
        "MaximumLongitude": -93.0,
        "Height": CELL_050,
        "Width": CELL_050,
        "Mask": os.path.join(STATIC_PATH, "win_cena102.bil"),
        "Map": os.path.join(MAP_PATH, "Central_America.bna"),
        "DefaultReg": "No",
        "Comments": "Central America Season (Aug-Dec)",
        "InitialPeriod": 21,
        "FinalPeriod": 36,
        "PeriodType": "Dekadal",
        "SOS": os.path.join(DATA_PATH, "Central_America", "SOS", "soscena2lta.bil"),
        "WRSI": os.path.join(STATIC_PATH, "wrsicena2p5.bil"),
        "LGP": os.path.join(STATIC_PATH, "lgp_cena2p5.bil"),
        "WHC": os.path.join(STATIC_PATH, "whc_cena.bil"),
        "SOSColor": os.path.join(COLOR_PATH, "sos_jul_sep_dekads.qml")},
    "Chad": {
        "MinimumLatitude": 6.625,
        "MaximumLatitude": 24.275,
        "MinimumLongitude": 12.925,
        "MaximumLongitude": 24.525,
        "Height": CELL_050,
        "Width": CELL_050,
        "Mask": os.path.join(STATIC_PATH, "Chad_adm2_mask.bil"),
        "Map": os.path.join(MAP_PATH, "Chad_adm2.shp"),
        "DefaultReg": "No",
        "Comments": "",
        "InitialPeriod": None,
        "FinalPeriod": None,
        "PeriodType": None,
        "SOS": None,
        "WRSI": None,
        "LGP": None,
        "WHC": None,
        "SOSColor": None},
    "Djibouti": {
        "MinimumLatitude": 10.8,
        "MaximumLatitude": 12.8,
        "MinimumLongitude": 41.7,
        "MaximumLongitude": 43.5,
        "Height": CELL_010,
        "Width": CELL_010,
        "Mask": os.path.join(STATIC_PATH, "Djibouti_adm1_mask.bil"),
        "Map": os.path.join(MAP_PATH, "djibouti_adm2.shp"),
        "DefaultReg": "No",
        "Comments": None,
        "InitialPeriod": None,
        "FinalPeriod": None,
        "PeriodType": None,
        "SOS": None,
        "WRSI": None,
        "LGP": None,
        "WHC": None,
        "SOSColor": None},
    "DR Congo": {
        "MinimumLatitude": -14.4,
        "MaximumLatitude": 6.3,
        "MinimumLongitude": 11.3,
        "MaximumLongitude": 32.3,
        "Height": CELL_050,
        "Width": CELL_050,
        "Mask": os.path.join(STATIC_PATH, "cd_adm1_mask.bil"),
        "Map": os.path.join(MAP_PATH, "cd_adm3.shp"),
        "DefaultReg": "No",
        "Comments": "D.R. Congo Main Summer Season",
        "InitialPeriod": 25,
        "FinalPeriod": 15,
        "PeriodType": "Dekadal",
        "SOS": os.path.join(DATA_PATH, "Africa", "SOS", "sosmedn_edc_s.bil"),
        "WRSI": os.path.join(STATIC_PATH, "wsimedn_edc_s.bil"),
        "LGP": os.path.join(STATIC_PATH, "lgp_south.bil"),
        "WHC": os.path.join(STATIC_PATH, "whc3.bil"),
        "SOSColor": os.path.join(COLOR_PATH, "sos_sep_jan_dekads.qml")},
    "EAC": {
        "MinimumLatitude": -12.6,
        "MaximumLatitude": 5.5,
        "MinimumLongitude": 28.2,
        "MaximumLongitude": 42.5,
        "Height": CELL_050,
        "Width": CELL_050,
        "Mask": os.path.join(STATIC_PATH, "EAC_adm0_mask.bil"),
        "Map": os.path.join(MAP_PATH, "EAC_adm0.shp"),
        "DefaultReg": "Yes",
        "Comments": None,
        "InitialPeriod": None,
        "FinalPeriod": None,
        "PeriodType": None,
        "SOS": None,
        "WRSI": None,
        "LGP": None,
        "WHC": None,
        "SOSColor": None},
    "East Africa Feb-Jul": {
        "MinimumLatitude": -11.7,
        "MaximumLatitude": 23.0,
        "MinimumLongitude": 22.0,
        "MaximumLongitude": 51.3,
        "Height": CELL_100,
        "Width": CELL_100,
        "Mask": os.path.join(STATIC_PATH, "win_east2.bil"),
        "Map": os.path.join(MAP_PATH, "Africa.shp"),
        "DefaultReg": "No",
        "Comments": "East Africa Feb-Jul (Rangelands long rains)",
        "InitialPeriod": 25,
        "FinalPeriod": 6,
        "PeriodType": "Dekadal",
        "SOS": os.path.join(DATA_PATH, "Africa", "SOS", "soseast2.bil"),
        "WRSI": os.path.join(STATIC_PATH, "wrsieast2.bil"),
        "LGP": os.path.join(STATIC_PATH, "lgp_east2.bil"),
        "WHC": os.path.join(STATIC_PATH, "whc3.bil"),
        "SOSColor": os.path.join(COLOR_PATH, "sos_feb_may_dekads.qml")},
    "East Africa Mar-Sep": {
        "MinimumLatitude": -11.7,
        "MaximumLatitude": 23.0,
        "MinimumLongitude": 22.0,
        "MaximumLongitude": 51.3,
        "Height": CELL_100,
        "Width": CELL_100,
        "Mask": os.path.join(STATIC_PATH, "win_eastk.bil"),
        "Map": os.path.join(MAP_PATH, "Africa.shp"),
        "DefaultReg": "No",
        "Comments": "Belg Season",
        "InitialPeriod": 4,
        "FinalPeriod": 27,
        "PeriodType": "Dekadal",
        "SOS": os.path.join(DATA_PATH, "Africa", "SOS", "soseastk.bil"),
        "WRSI": os.path.join(STATIC_PATH, "wrsieastk.bil"),
        "LGP": os.path.join(STATIC_PATH, "lgp_eastk.bil"),
        "WHC": os.path.join(STATIC_PATH, "whc3.bil"),
        "SOSColor": os.path.join(COLOR_PATH, "sos_feb_may_dekads.qml")},
    "East Africa Mar-Nov": {
        "MinimumLatitude": -11.7,
        "MaximumLatitude": 23.0,
        "MinimumLongitude": 22.0,
        "MaximumLongitude": 51.3,
        "Height": CELL_100,
        "Width": CELL_100,
        "Mask": os.path.join(STATIC_PATH, "win_easte.bil"),
        "Map": os.path.join(MAP_PATH, "Africa.shp"),
        "DefaultReg": "No",
        "Comments": "Long Rains Season",
        "InitialPeriod": 10,
        "FinalPeriod": 33,
        "PeriodType": "Dekadal",
        "SOS": os.path.join(DATA_PATH, "Africa", "SOS", "soseaste.bil"),
        "WRSI": os.path.join(STATIC_PATH, "wrsieaste.bil"),
        "LGP": os.path.join(STATIC_PATH, "lgp_easte.bil"),
        "WHC": os.path.join(STATIC_PATH, "whc3.bil"),
        "SOSColor": os.path.join(COLOR_PATH, "sos_apr_aug_dekads.qml")},
    "East Africa Sep-Jan": {
        "MinimumLatitude": -11.7,
        "MaximumLatitude": 23.0,
        "MinimumLongitude": 22.0,
        "MaximumLongitude": 51.3,
        "Height": CELL_100,
        "Width": CELL_100,
        "Mask": os.path.join(STATIC_PATH, "win_east1.bil"),
        "Map": os.path.join(MAP_PATH, "Africa.shp"),
        "DefaultReg": "No",
        "Comments": "East Africa Sep-Jan (Rangelands short rains)",
        "InitialPeriod": 25,
        "FinalPeriod": 6,
        "PeriodType": "Dekadal",
        "SOS": os.path.join(DATA_PATH, "Africa", "SOS", "soseast1.bil"),
        "WRSI": os.path.join(STATIC_PATH, "wrsieast1.bil"),
        "LGP": os.path.join(STATIC_PATH, "lgp_east1.bil"),
        "WHC": os.path.join(STATIC_PATH, "whc3.bil"),
        "SOSColor": os.path.join(COLOR_PATH, "sos_sep_dec_dekads.qml")},
    "East Africa Oct-Feb": {
        "MinimumLatitude": -11.7,
        "MaximumLatitude": 23.0,
        "MinimumLongitude": 22.0,
        "MaximumLongitude": 51.3,
        "Height": CELL_100,
        "Width": CELL_100,
        "Mask": os.path.join(STATIC_PATH, "win_eastt.bil"),
        "Map": os.path.join(MAP_PATH, "Africa.shp"),
        "DefaultReg": "No",
        "Comments": "East Africa Oct-Feb (Short Season)",
        "InitialPeriod": 25,
        "FinalPeriod": 6,
        "PeriodType": "Dekadal",
        "SOS": os.path.join(DATA_PATH, "Africa", "SOS", "soseastt.bil"),
        "WRSI": os.path.join(STATIC_PATH, "wrsieastt.bil"),
        "LGP": os.path.join(STATIC_PATH, "lgp_eastt.bil"),
        "WHC": os.path.join(STATIC_PATH, "whc3.bil"),
        "SOSColor": os.path.join(COLOR_PATH, "sos_sep_dec_dekads.qml")},
    "Eritrea": {
        "MinimumLatitude": 12.0,
        "MaximumLatitude": 18.3,
        "MinimumLongitude": 36.1,
        "MaximumLongitude": 43.5,
        "Height": CELL_025,
        "Width": CELL_025,
        "Mask": os.path.join(STATIC_PATH, "eritrea_adm1_mask.bil"),
        "Map": os.path.join(MAP_PATH, "eritrea_adm2.shp"),
        "DefaultReg": "No",
        "Comments": None,
        "InitialPeriod": None,
        "FinalPeriod": None,
        "PeriodType": None,
        "SOS": None,
        "WRSI": None,
        "LGP": None,
        "WHC": None,
        "SOSColor": None},
    "Ethiopia": {
        "MinimumLatitude": 2.8,
        "MaximumLatitude": 15.5,
        "MinimumLongitude": 32.2,
        "MaximumLongitude": 48.7,
        "Height": CELL_050,
        "Width": CELL_050,
        "Mask": os.path.join(STATIC_PATH, "Ethiopia_adm1_mask.bil"),
        "Map": os.path.join(MAP_PATH, "ethiopia_adm2.shp"),
        "DefaultReg": "No",
        "Comments": None,
        "InitialPeriod": None,
        "FinalPeriod": None,
        "PeriodType": None,
        "SOS": None,
        "WRSI": None,
        "LGP": None,
        "WHC": None,
        "SOSColor": None},
    "Gambia": {
        "MinimumLatitude": 1.0,
        "MaximumLatitude": 13.7,
        "MinimumLongitude": 8.1,
        "MaximumLongitude": 16.6,
        "Height": CELL_050,
        "Width": CELL_050,
        "Mask": os.path.join(STATIC_PATH, "Gambie_adm2_mask.bil"),
        "Map": os.path.join(MAP_PATH, "Gambie_adm2.shp"),
        "DefaultReg": "No",
        "Comments": None,
        "InitialPeriod": None,
        "FinalPeriod": None,
        "PeriodType": None,
        "SOS": None,
        "WRSI": None,
        "LGP": None,
        "WHC": None,
        "SOSColor": None},
    "GHA": {
        "MinimumLatitude": -2.7,
        "MaximumLatitude": 19.0,
        "MinimumLongitude": 32.0,
        "MaximumLongitude": 52.3,
        "Height": CELL_050,
        "Width": CELL_050,
        "Mask": os.path.join(STATIC_PATH, "GHA_adm0_mask.bil"),
        "Map": os.path.join(MAP_PATH, "GHA_adm0.shp"),
        "DefaultReg": "No",
        "Comments": None,
        "InitialPeriod": None,
        "FinalPeriod": None,
        "PeriodType": None,
        "SOS": None,
        "WRSI": None,
        "LGP": None,
        "WHC": None,
        "SOSColor": None},
    "Ghana": {
        "MinimumLatitude": 4.4,
        "MaximumLatitude": 11.5,
        "MinimumLongitude": -3.5,
        "MaximumLongitude": 1.5,
        "Height": CELL_050,
        "Width": CELL_050,
        "Mask": os.path.join(STATIC_PATH, "Ghana_adm2_mask.bil"),
        "Map": os.path.join(MAP_PATH, "Ghana_adm2.shp"),
        "DefaultReg": "No",
        "Comments": None,
        "InitialPeriod": None,
        "FinalPeriod": None,
        "PeriodType": None,
        "SOS": None,
        "WRSI": None,
        "LGP": None,
        "WHC": None,
        "SOSColor": None},
    "Guinee": {
        "MinimumLatitude": 6.9,
        "MaximumLatitude": 12.95,
        "MinimumLongitude": -15.5,
        "MaximumLongitude": -7.25,
        "Height": CELL_050,
        "Width": CELL_050,
        "Mask": os.path.join(STATIC_PATH, "GuineConakry_adm2_mask.bil"),
        "Map": os.path.join(MAP_PATH, "GuineConakry_adm2.shp"),
        "DefaultReg": "No",
        "Comments": None,
        "InitialPeriod": None,
        "FinalPeriod": None,
        "PeriodType": None,
        "SOS": None,
        "WRSI": None,
        "LGP": None,
        "WHC": None,
        "SOSColor": None},
    "Guine-Bissau": {
        "MinimumLatitude": 10.75,
        "MaximumLatitude": 12.8,
        "MinimumLongitude": -16.9,
        "MaximumLongitude": -13.45,
        "Height": CELL_050,
        "Width": CELL_050,
        "Mask": os.path.join(STATIC_PATH, "GuineeBissau_adm2_mask.bil"),
        "Map": os.path.join(MAP_PATH, "GuineeBissau_adm2.shp"),
        "DefaultReg": "No",
        "Comments": None,
        "InitialPeriod": None,
        "FinalPeriod": None,
        "PeriodType": None,
        "SOS": None,
        "WRSI": None,
        "LGP": None,
        "WHC": None,
        "SOSColor": None},
    "Haiti Apr-Sep": {
        "MinimumLatitude": 17.65,
        "MaximumLatitude": 20.05,
        "MinimumLongitude": -74.4,
        "MaximumLongitude": -74.4,
        "Height": CELL_050,
        "Width": CELL_050,
        "Mask": os.path.join(STATIC_PATH, "win_haiti105.bil"),
        "Map": os.path.join(MAP_PATH, "Central_America.bna"),
        "DefaultReg": "No",
        "Comments": "Haiti Season (Apr-Sep)",
        "InitialPeriod": 7,
        "FinalPeriod": 30,
        "PeriodType": "Dekadal",
        "SOS": os.path.join(DATA_PATH, "Central_America", "SOS", "soshaiti1lta.bil"),
        "WRSI": os.path.join(STATIC_PATH, "wrsihaiti1p5.bil"),
        "LGP": os.path.join(STATIC_PATH, "lgp_haiti1p5.bil"),
        "WHC": os.path.join(STATIC_PATH, "whc100haiti.bil"),
        "SOSColor": os.path.join(COLOR_PATH, "sos_apr_aug_dekads.qml")},
    "Haiti Aug-Dec": {
        "MinimumLatitude": 17.65,
        "MaximumLatitude": 20.05,
        "MinimumLongitude": -74.4,
        "MaximumLongitude": -74.4,
        "Height": CELL_050,
        "Width": CELL_050,
        "Mask": os.path.join(STATIC_PATH, "win_haiti205.bil"),
        "Map": os.path.join(MAP_PATH, "Central_America.bna"),
        "DefaultReg": "No",
        "Comments": "Haiti Season (Aug-Dec)",
        "InitialPeriod": 21,
        "FinalPeriod": 36,
        "PeriodType": "Dekadal",
        "SOS": os.path.join(DATA_PATH, "Central_America", "SOS", "soshaiti2lta.bil"),
        "WRSI": os.path.join(STATIC_PATH, "wrsihaiti2p5.bil"),
        "LGP": os.path.join(STATIC_PATH, "lgp_haiti2p5.bil"),
        "WHC": os.path.join(STATIC_PATH, "whc100haiti.bil"),
        "SOSColor": os.path.join(COLOR_PATH, "sos_jul_sep_dekads2.qml")},
    "IGAD": {
        "MinimumLatitude": -13.5,
        "MaximumLatitude": 24.7,
        "MinimumLongitude": 20.3,
        "MaximumLongitude": 52.9,
        "Height": CELL_050,
        "Width": CELL_050,
        "Mask": os.path.join(STATIC_PATH, "IGAD_adm0_mask.bil"),
        "Map": os.path.join(MAP_PATH, "IGAD_adm0.shp"),
        "DefaultReg": "No",
        "Comments": None,
        "InitialPeriod": None,
        "FinalPeriod": None,
        "PeriodType": None,
        "SOS": None,
        "WRSI": None,
        "LGP": None,
        "WHC": None,
        "SOSColor": None},
    "Kenya": {
        "MinimumLatitude": -5.2,
        "MaximumLatitude": 5.1,
        "MinimumLongitude": 33.5,
        "MaximumLongitude": 42.3,
        "Height": CELL_050,
        "Width": CELL_050,
        "Mask": os.path.join(STATIC_PATH, "kenya_adm1_mask.bil"),
        "Map": os.path.join(MAP_PATH, "kenya_adm2.shp"),
        "DefaultReg": "No",
        "Comments": None,
        "InitialPeriod": None,
        "FinalPeriod": None,
        "PeriodType": None,
        "SOS": None,
        "WRSI": None,
        "LGP": None,
        "WHC": None,
        "SOSColor": None},
    "Lesotho": {
        "MinimumLatitude": -30.8,
        "MaximumLatitude": -28.5,
        "MinimumLongitude": 26.9,
        "MaximumLongitude": 29.6,
        "Height": CELL_010,
        "Width": CELL_010,
        "Mask": os.path.join(STATIC_PATH, "ls_adm1_mask.bil"),
        "Map": os.path.join(MAP_PATH, "ls_adm2.shp"),
        "DefaultReg": "No",
        "Comments": "Lesotho Main Summer Season",
        "InitialPeriod": 25,
        "FinalPeriod": 15,
        "PeriodType": "Dekadal",
        "SOS": os.path.join(DATA_PATH, "Africa", "SOS", "sosmedn_edc_s.bil"),
        "WRSI": os.path.join(STATIC_PATH, "wsimedn_edc_s.bil"),
        "LGP": os.path.join(STATIC_PATH, "lgp_south.bil"),
        "WHC": os.path.join(STATIC_PATH, "whc3.bil"),
        "SOSColor": os.path.join(COLOR_PATH, "sos_sep_jan_dekads.qml")},
    "Liberia": {
        "MinimumLatitude": 4.1,
        "MaximumLatitude": 8.8,
        "MinimumLongitude": -11.7,
        "MaximumLongitude": -7.15,
        "Height": CELL_050,
        "Width": CELL_050,
        "Mask": os.path.join(STATIC_PATH, "Liberia_adm2_mask.bil"),
        "Map": os.path.join(MAP_PATH, "Liberia_adm2.shp"),
        "DefaultReg": "No",
        "Comments": None,
        "InitialPeriod": None,
        "FinalPeriod": None,
        "PeriodType": None,
        "SOS": None,
        "WRSI": None,
        "LGP": None,
        "WHC": None,
        "SOSColor": None},
    "Madagascar": {
        "MinimumLatitude": -26.3,
        "MaximumLatitude": -11.3,
        "MinimumLongitude": 42.3,
        "MaximumLongitude": 50.9,
        "Height": CELL_050,
        "Width": CELL_050,
        "Mask": os.path.join(STATIC_PATH, "mg_adm1_mask.bil"),
        "Map": os.path.join(MAP_PATH, "mg_adm1.shp"),
        "DefaultReg": "No",
        "Comments": "Madagascar Main Summer Season",
        "InitialPeriod": 25,
        "FinalPeriod": 15,
        "PeriodType": "Dekadal",
        "SOS": os.path.join(DATA_PATH, "Africa", "SOS", "sosmedn_edc_s.bil"),
        "WRSI": os.path.join(STATIC_PATH, "wsimedn_edc_s.bil"),
        "LGP": os.path.join(STATIC_PATH, "lgp_south.bil"),
        "WHC": os.path.join(STATIC_PATH, "whc3.bil"),
        "SOSColor": os.path.join(COLOR_PATH, "sos_sep_jan_dekads.qml")},
    "Malawi": {
        "MinimumLatitude": -17.5,
        "MaximumLatitude": -9.0,
        "MinimumLongitude": 32.5,
        "MaximumLongitude": 36.1,
        "Height": CELL_050,
        "Width": CELL_050,
        "Mask": os.path.join(STATIC_PATH, "mw_adm1_mask.bil"),
        "Map": os.path.join(MAP_PATH, "mw_adm1.shp"),
        "DefaultReg": "No",
        "Comments": "Malawi Main Summer Season",
        "InitialPeriod": 25,
        "FinalPeriod": 15,
        "PeriodType": "Dekadal",
        "SOS": os.path.join(DATA_PATH, "Africa", "SOS", "sosmedn_edc_s.bil"),
        "WRSI": os.path.join(STATIC_PATH, "wsimedn_edc_s.bil"),
        "LGP": os.path.join(STATIC_PATH, "lgp_south.bil"),
        "WHC": os.path.join(STATIC_PATH, "whc3.bil"),
        "SOSColor": os.path.join(COLOR_PATH, "sos_sep_jan_dekads.qml")},
    "Mali": {
        "MinimumLatitude": 9.4,
        "MaximumLatitude": 25.8,
        "MinimumLongitude": -13.1,
        "MaximumLongitude": 5.1,
        "Height": CELL_050,
        "Width": CELL_050,
        "Mask": os.path.join(STATIC_PATH, "Mali_adm2_mask.bil"),
        "Map": os.path.join(MAP_PATH, "Mali_adm2.shp"),
        "DefaultReg": "No",
        "Comments": None,
        "InitialPeriod": None,
        "FinalPeriod": None,
        "PeriodType": None,
        "SOS": None,
        "WRSI": None,
        "LGP": None,
        "WHC": None,
        "SOSColor": None},
    "Mauritanie": {
        "MinimumLatitude": 14.1,
        "MaximumLatitude": 28.0,
        "MinimumLongitude": -17.7,
        "MaximumLongitude": -4.2,
        "Height": CELL_050,
        "Width": CELL_050,
        "Mask": os.path.join(STATIC_PATH, "Mauritanie_adm2_mask.bil"),
        "Map": os.path.join(MAP_PATH, "Mauritanie_adm2.shp"),
        "DefaultReg": "No",
        "Comments": None,
        "InitialPeriod": None,
        "FinalPeriod": None,
        "PeriodType": None,
        "SOS": None,
        "WRSI": None,
        "LGP": None,
        "WHC": None,
        "SOSColor": None},
    "Mozambique": {
        "MinimumLatitude": -27.7,
        "MaximumLatitude": -9.7,
        "MinimumLongitude": 29.7,
        "MaximumLongitude": 41.4,
        "Height": CELL_050,
        "Width": CELL_050,
        "Mask": os.path.join(STATIC_PATH, "mz_adm1_mask.bil"),
        "Map": os.path.join(MAP_PATH, "mz_adm3.shp"),
        "DefaultReg": "No",
        "Comments": "Mozambique Main Summer Season",
        "InitialPeriod": 25,
        "FinalPeriod": 15,
        "PeriodType": "Dekadal",
        "SOS": os.path.join(DATA_PATH, "Africa", "SOS", "sosmedn_edc_s.bil"),
        "WRSI": os.path.join(STATIC_PATH, "wsimedn_edc_s.bil"),
        "LGP": os.path.join(STATIC_PATH, "lgp_south.bil"),
        "WHC": os.path.join(STATIC_PATH, "whc3.bil"),
        "SOSColor": os.path.join(COLOR_PATH, "sos_sep_jan_dekads.qml")},
    "Namibia": {
        "MinimumLatitude": -29.6,
        "MaximumLatitude": -16.4,
        "MinimumLongitude": 11.0,
        "MaximumLongitude": 25.9,
        "Height": CELL_050,
        "Width": CELL_050,
        "Mask": os.path.join(STATIC_PATH, "na_adm1_mask.bil"),
        "Map": os.path.join(MAP_PATH, "na_adm3.shp"),
        "DefaultReg": "No",
        "Comments": "Namibia Main Summer Season",
        "InitialPeriod": 25,
        "FinalPeriod": 15,
        "PeriodType": "Dekadal",
        "SOS": os.path.join(DATA_PATH, "Africa", "SOS", "sosmedn_edc_s.bil"),
        "WRSI": os.path.join(STATIC_PATH, "wsimedn_edc_s.bil"),
        "LGP": os.path.join(STATIC_PATH, "lgp_south.bil"),
        "WHC": os.path.join(STATIC_PATH, "whc3.bil"),
        "SOSColor": os.path.join(COLOR_PATH, "sos_sep_jan_dekads.qml")},
    "Niger": {
        "MinimumLatitude": 11.1,
        "MaximumLatitude": 24.2,
        "MinimumLongitude": -0.7,
        "MaximumLongitude": 16.8,
        "Height": CELL_050,
        "Width": CELL_050,
        "Mask": os.path.join(STATIC_PATH, "Niger_adm2_mask.bil"),
        "Map": os.path.join(MAP_PATH, "Niger_adm2.shp"),
        "DefaultReg": "No",
        "Comments": None,
        "InitialPeriod": None,
        "FinalPeriod": None,
        "PeriodType": None,
        "SOS": None,
        "WRSI": None,
        "LGP": None,
        "WHC": None,
        "SOSColor": None},
    "Nigeria": {
        "MinimumLatitude": 4.0,
        "MaximumLatitude": 11.1,
        "MinimumLongitude": -8.9,
        "MaximumLongitude": -2.15,
        "Height": CELL_050,
        "Width": CELL_050,
        "Mask": os.path.join(STATIC_PATH, "Nigeria_adm2_mask.bil"),
        "Map": os.path.join(MAP_PATH, "Nigeria_adm2.shp"),
        "DefaultReg": "No",
        "Comments": None,
        "InitialPeriod": None,
        "FinalPeriod": None,
        "PeriodType": None,
        "SOS": None,
        "WRSI": None,
        "LGP": None,
        "WHC": None,
        "SOSColor": None},
    "Rwanda": {
        "MinimumLatitude": -3.0,
        "MaximumLatitude": -0.9,
        "MinimumLongitude": 28.7,
        "MaximumLongitude": 31.0,
        "Height": CELL_010,
        "Width": CELL_010,
        "Mask": os.path.join(STATIC_PATH, "rwanda_adm1_mask.bil"),
        "Map": os.path.join(MAP_PATH, "rwanda_adm2.shp"),
        "DefaultReg": "No",
        "Comments": None,
        "InitialPeriod": None,
        "FinalPeriod": None,
        "PeriodType": None,
        "SOS": None,
        "WRSI": None,
        "LGP": None,
        "WHC": None,
        "SOSColor": None},
    "SADC": {
        "MinimumLatitude": -34.75,
        "MaximumLatitude": 5.35,
        "MinimumLongitude": 11.85,
        "MaximumLongitude": 50.45,
        "Height": CELL_100,
        "Width": CELL_100,
        "Mask": os.path.join(STATIC_PATH, "dc_tiny_mask.bil"),
        "Map": os.path.join(MAP_PATH, "dc_tiny.shp"),
        "DefaultReg": "No",
        "Comments": "SADC Main Summer Season",
        "InitialPeriod": 25,
        "FinalPeriod": 15,
        "PeriodType": "Dekadal",
        "SOS": os.path.join(DATA_PATH, "Africa", "SOS", "sosmedn_edc_s.bil"),
        "WRSI": os.path.join(STATIC_PATH, "wsimedn_edc_s.bil"),
        "LGP": os.path.join(STATIC_PATH, "lgp_south.bil"),
        "WHC": os.path.join(STATIC_PATH, "whc3.bil"),
        "SOSColor": os.path.join(COLOR_PATH, "sos_sep_jan_dekads.qml")},
    "Senegal": {
        "MinimumLatitude": 12.05,
        "MaximumLatitude": 16.95,
        "MinimumLongitude": -17.85,
        "MaximumLongitude": -11.05,
        "Height": CELL_050,
        "Width": CELL_050,
        "Mask": os.path.join(STATIC_PATH, "Senegal_adm2_mask.bil"),
        "Map": os.path.join(MAP_PATH, "Senegal_adm2.shp"),
        "DefaultReg": "No",
        "Comments": None,
        "InitialPeriod": None,
        "FinalPeriod": None,
        "PeriodType": None,
        "SOS": None,
        "WRSI": None,
        "LGP": None,
        "WHC": None,
        "SOSColor": None},
    "Sierra Leonne": {
        "MinimumLatitude": 6.75,
        "MaximumLatitude": 10.15,
        "MinimumLongitude": -13.5,
        "MaximumLongitude": -10.1,
        "Height": CELL_050,
        "Width": CELL_050,
        "Mask": os.path.join(STATIC_PATH, "SierraLeonne_adm2_mask.bil"),
        "Map": os.path.join(MAP_PATH, "SierraLeonne_adm2.shp"),
        "DefaultReg": "No",
        "Comments": None,
        "InitialPeriod": None,
        "FinalPeriod": None,
        "PeriodType": None,
        "SOS": None, "WRSI": None,
        "LGP": None, "WHC": None,
        "SOSColor": None},
    "Somalia": {
        "MinimumLatitude": -2.4,
        "MaximumLatitude": 12.7,
        "MinimumLongitude": 40.5,
        "MaximumLongitude": 52.0,
        "Height": CELL_050,
        "Width": CELL_050,
        "Mask": os.path.join(STATIC_PATH, "Somalia_adm1_mask.bil"),
        "Map": os.path.join(MAP_PATH, "somalia_adm2.shp"),
        "DefaultReg": "No",
        "Comments": None,
        "InitialPeriod": None,
        "FinalPeriod": None,
        "PeriodType": None,
        "SOS": None,
        "WRSI": None,
        "LGP": None,
        "WHC": None,
        "SOSColor": None},
    "South Africa": {
        "MinimumLatitude": -35.5,
        "MaximumLatitude": -21.5,
        "MinimumLongitude": 15.6,
        "MaximumLongitude": 33.7,
        "Height": CELL_050,
        "Width": CELL_050,
        "Mask": os.path.join(STATIC_PATH, "za_adm1_mask.bil"),
        "Map": os.path.join(MAP_PATH, "za_adm3.shp"),
        "DefaultReg": "No",
        "Comments": "South Africa Main Summer Season",
        "InitialPeriod": 25,
        "FinalPeriod": 15,
        "PeriodType": "Dekadal",
        "SOS": os.path.join(DATA_PATH, "Africa", "SOS", "sosmedn_edc_s.bil"),
        "WRSI": os.path.join(STATIC_PATH, "wsimedn_edc_s.bil"),
        "LGP": os.path.join(STATIC_PATH, "lgp_south.bil"),
        "WHC": os.path.join(STATIC_PATH, "whc3.bil"),
        "SOSColor": os.path.join(COLOR_PATH, "sos_sep_jan_dekads.qml")},
    "Southern Africa": {
        "MinimumLatitude": -37.9,
        "MaximumLatitude": 6.3,
        "MinimumLongitude": 6.0,
        "MaximumLongitude": 6.0,
        "Height": CELL_100,
        "Width": CELL_100,
        "Mask": os.path.join(STATIC_PATH, "win_south.bil"),
        "Map": os.path.join(MAP_PATH, "dc_adm1.shp"),
        "DefaultReg": "No",
        "Comments": "Southern Africa main summer maize season",
        "InitialPeriod": 25,
        "FinalPeriod": 15,
        "PeriodType": "Dekadal",
        "SOS": os.path.join(DATA_PATH, "Africa", "SOS", "sossouth.bil"),
        "WRSI": os.path.join(STATIC_PATH, "wrsisouth.bil"),
        "LGP": os.path.join(STATIC_PATH, "lgp_south.bil"),
        "WHC": os.path.join(STATIC_PATH, "whc3.bil"),
        "SOSColor": os.path.join(COLOR_PATH, "sos_sep_jan_dekads.qml")},
    "South Sudan": {
        "MinimumLatitude": 3.0,
        "MaximumLatitude": 12.7,
        "MinimumLongitude": 23.5,
        "MaximumLongitude": 36.5,
        "Height": CELL_050,
        "Width": CELL_050,
        "Mask": os.path.join(STATIC_PATH, "SouthSudan_adm1_mask.bil"),
        "Map": os.path.join(MAP_PATH, "SouthSudan_adm1.shp"),
        "DefaultReg": "No",
        "Comments": None,
        "InitialPeriod": None,
        "FinalPeriod": None,
        "PeriodType": None,
        "SOS": None,
        "WRSI": None,
        "LGP": None,
        "WHC": None,
        "SOSColor": None},
    "Sudan": {
        "MinimumLatitude": 7.9,
        "MaximumLatitude": 23.7,
        "MinimumLongitude": 21.0,
        "MaximumLongitude": 39.4,
        "Height": CELL_050,
        "Width": CELL_050,
        "Mask": os.path.join(STATIC_PATH, "Sudan_adm1_mask.bil"),
        "Map": os.path.join(MAP_PATH, "Sudan_adm1.shp"),
        "DefaultReg": "No",
        "Comments": None,
        "InitialPeriod": None,
        "FinalPeriod": None,
        "PeriodType": None,
        "SOS": None,
        "WRSI": None,
        "LGP": None,
        "WHC": None,
        "SOSColor": None},
    "Swaziland": {
        "MinimumLatitude": -27.4,
        "MaximumLatitude": -25.6,
        "MinimumLongitude": 30.7,
        "MaximumLongitude": 32.2,
        "Height": CELL_010,
        "Width": CELL_010,
        "Mask": os.path.join(STATIC_PATH, "sz_adm1_mask.bil"),
        "Map": os.path.join(MAP_PATH, "sz_adm2.shp"),
        "DefaultReg": "No",
        "Comments": "Swaziland Main Summer Season",
        "InitialPeriod": 25,
        "FinalPeriod": 15,
        "PeriodType": "Dekadal",
        "SOS": os.path.join(DATA_PATH, "Africa", "SOS", "sosmedn_edc_s.bil"),
        "WRSI": os.path.join(STATIC_PATH, "wsimedn_edc_s.bil"),
        "LGP": os.path.join(STATIC_PATH, "lgp_south.bil"),
        "WHC": os.path.join(STATIC_PATH, "whc3.bil"),
        "SOSColor": os.path.join(COLOR_PATH, "sos_sep_jan_dekads.qml")},
    "Tanzania": {
        "MinimumLatitude": -12.3,
        "MaximumLatitude": -0.4,
        "MinimumLongitude": 28.7,
        "MaximumLongitude": 41.0,
        "Height": CELL_050,
        "Width": CELL_050,
        "Mask": os.path.join(STATIC_PATH, "tanzania_adm1_mask.bil"),
        "Map": os.path.join(MAP_PATH, "tanzania_adm2.shp"),
        "DefaultReg": "No",
        "Comments": "Tanzania Main Summer Season",
        "InitialPeriod": 25,
        "FinalPeriod": 15,
        "PeriodType": "Dekadal",
        "SOS": os.path.join(DATA_PATH, "Africa", "SOS", "sosmedn_edc_s.bil"),
        "WRSI": os.path.join(STATIC_PATH, "wsimedn_edc_s.bil"),
        "LGP": os.path.join(STATIC_PATH, "lgp_south.bil"),
        "WHC": os.path.join(STATIC_PATH, "whc3.bil"),
        "SOSColor": os.path.join(COLOR_PATH, "sos_sep_jan_dekads.qml")},
    "Togo": {
        "MinimumLatitude": 5.85,
        "MaximumLatitude": 11.4,
        "MinimumLongitude": -0.25,
        "MaximumLongitude": 1.9,
        "Height": CELL_050,
        "Width": CELL_050,
        "Mask": os.path.join(STATIC_PATH, "Togo_adm2_mask.bil"),
        "Map": os.path.join(MAP_PATH, "Togo_adm2.shp"),
        "DefaultReg": "No",
        "Comments": None,
        "InitialPeriod": None,
        "FinalPeriod": None,
        "PeriodType": None,
        "SOS": None,
        "WRSI": None,
        "LGP": None,
        "WHC": None,
        "SOSColor": None},
    "Uganda": {
        "MinimumLatitude": -1.8,
        "MaximumLatitude": 4.5,
        "MinimumLongitude": 29.3,
        "MaximumLongitude": 35.3,
        "Height": CELL_050,
        "Width": CELL_050,
        "Mask": os.path.join(STATIC_PATH, "uganda_adm1_mask.bil"),
        "Map": os.path.join(MAP_PATH, "uganda_adm2.shp"),
        "DefaultReg": "No",
        "Comments": None,
        "InitialPeriod": None,
        "FinalPeriod": None,
        "PeriodType": None,
        "SOS": None,
        "WRSI": None,
        "LGP": None,
        "WHC": None,
        "SOSColor": None},
    "West Africa": {
        "MinimumLatitude": 0.325,
        "MaximumLatitude": 28.575,
        "MinimumLongitude": -19.575,
        "MaximumLongitude": 25.975,
        "Height": CELL_100,
        "Width": CELL_100,
        "Mask": os.path.join(STATIC_PATH, "west_africa_adm1_mask.bil"),
        "Map": os.path.join(MAP_PATH, "west_africa_adm1.shp"),
        "DefaultReg": "No",
        "Comments": "West Africa (Rangelands)",
        "InitialPeriod": 10,
        "FinalPeriod": 33,
        "PeriodType": "Dekadal",
        "SOS": os.path.join(DATA_PATH, "Africa", "SOS", "soswest1.bil"),
        "WRSI": os.path.join(STATIC_PATH, "wrsiwest1.bil"),
        "LGP": os.path.join(STATIC_PATH, "lgp_west1.bil"),
        "WHC": os.path.join(STATIC_PATH, "whc3.bil"),
        "SOSColor": os.path.join(COLOR_PATH, "sos_may_aug_dekads.qml")},
    "West Sahel Africa": {
        "MinimumLatitude": 5.3,
        "MaximumLatitude": 17.6,
        "MinimumLongitude": -18.6,
        "MaximumLongitude": -18.6,
        "Height": CELL_100,
        "Width": CELL_100,
        "Mask": os.path.join(STATIC_PATH, "win_west.bil"),
        "Map": os.path.join(MAP_PATH, "Africa.bna"),
        "DefaultReg": "No",
        "Comments": "West Africa Main Summer Season",
        "InitialPeriod": 10,
        "FinalPeriod": 33,
        "PeriodType": "Dekadal",
        "SOS": os.path.join(DATA_PATH, "Africa", "SOS", "soswest.bil"),
        "WRSI": os.path.join(STATIC_PATH, "wrsiwest.bil"),
        "LGP": os.path.join(STATIC_PATH, "lgp_west.bil"),
        "WHC": os.path.join(STATIC_PATH, "whc3.bil"),
        "SOSColor": os.path.join(COLOR_PATH, "sos_apr_aug_dekads.qml")},
    "Zambia": {
        "MinimumLatitude": -18.6,
        "MaximumLatitude": -7.7,
        "MinimumLongitude": 21.4,
        "MaximumLongitude": 34.3,
        "Height": CELL_050,
        "Width": CELL_050,
        "Mask": os.path.join(STATIC_PATH, "zm_adm1_mask.bil"),
        "Map": os.path.join(MAP_PATH, "zm_adm3.shp"),
        "DefaultReg": "No",
        "Comments": "Zambia Main Summer Season",
        "InitialPeriod": 25,
        "FinalPeriod": 15,
        "PeriodType": "Dekadal",
        "SOS": os.path.join(DATA_PATH, "Africa", "SOS", "sosmedn_edc_s.bil"),
        "WRSI": os.path.join(STATIC_PATH, "wsimedn_edc_s.bil"),
        "LGP": os.path.join(STATIC_PATH, "lgp_south.bil"),
        "WHC": os.path.join(STATIC_PATH, "whc3.bil"),
        "SOSColor": os.path.join(COLOR_PATH, "sos_sep_jan_dekads.qml")},
    "Zimbabwe": {
        "MinimumLatitude": -22.8,
        "MaximumLatitude": -15.3,
        "MinimumLongitude": 24.8,
        "MaximumLongitude": 33.4,
        "Height": CELL_050,
        "Width": CELL_050,
        "Mask": os.path.join(STATIC_PATH, "zw_adm1_mask.bil"),
        "Map": os.path.join(MAP_PATH, "zw_adm3.shp"),
        "DefaultReg": "No",
        "Comments": "Zimbabwe Main Summer Season",
        "InitialPeriod": 25,
        "FinalPeriod": 15,
        "PeriodType": "Dekadal",
        "SOS": os.path.join(DATA_PATH, "Africa", "SOS", "sosmedn_edc_s.bil"),
        "WRSI": os.path.join(STATIC_PATH, "wsimedn_edc_s.bil"),
        "LGP": os.path.join(STATIC_PATH, "lgp_south.bil"),
        "WHC": os.path.join(STATIC_PATH, "whc3.bil"),
        "SOSColor": os.path.join(COLOR_PATH, "sos_sep_jan_dekads.qml")}

     }

REGION_TABLE_NAME = "Regions"
SQL_DROP_TABLE = "DROP TABLE if exists " + REGION_TABLE_NAME

SQL_CREATE_TABLE = ("CREATE TABLE " + REGION_TABLE_NAME +
                    " (RegionName TEXT NOT NULL UNIQUE, "
                    "MinimumLatitude REAL NOT NULL, "
                    "MaximumLatitude REAL NOT NULL, "
                    "MinimumLongitude REAL NOT NULL, "
                    "MaximumLongitude REAL NOT NULL, "
                    "Height REAL NOT NULL, "
                    "Width REAL NOT NULL, "
                    "Mask TEXT NOT NULL, "
                    "Map TEXT NOT NULL, "
                    "DefaultReg TEXT NOT NULL, "
                    "Comments VARCHAR(255), "
                    "InitialPeriod INT, "
                    "FinalPeriod INT, "
                    "PeriodType TEXT, "
                    "SOS TEXT, "
                    "WRSI TEXT, "
                    "LGP TEXT, "
                    "WHC TEXT, "
                    "SOSColor TEXT)")

INSERT_SQL = (
    "INSERT INTO " + REGION_TABLE_NAME +
    " (RegionName, MinimumLatitude, MaximumLatitude,"
    " MinimumLongitude, MaximumLongitude, Height, Width,"
    " Mask, Map, DefaultReg, Comments, InitialPeriod, FinalPeriod,"
    " PeriodType, SOS, WRSI, LGP, WHC, SOSColor)"
    " VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)")


print("Dropping table")
db_util.write_db(SQL_DROP_TABLE, (), config.EXAMPLE_DB_FILE)


print("Creating new Regions table")
db_util.write_db(SQL_CREATE_TABLE, (), config.EXAMPLE_DB_FILE)
print("Created new Regions table")


for key in REGION_TABLE_VALUES:
    print("Inserting region:  " + key)
    params = (
        key,
        REGION_TABLE_VALUES[key]["MinimumLatitude"],
        REGION_TABLE_VALUES[key]["MaximumLatitude"],
        REGION_TABLE_VALUES[key]["MinimumLongitude"],
        REGION_TABLE_VALUES[key]["MaximumLongitude"],
        REGION_TABLE_VALUES[key]["Height"],
        REGION_TABLE_VALUES[key]["Width"],
        REGION_TABLE_VALUES[key]["Mask"],
        REGION_TABLE_VALUES[key]["Map"],
        REGION_TABLE_VALUES[key]["DefaultReg"],
        REGION_TABLE_VALUES[key]["Comments"],
        REGION_TABLE_VALUES[key]["InitialPeriod"],
        REGION_TABLE_VALUES[key]["FinalPeriod"],
        REGION_TABLE_VALUES[key]["PeriodType"],
        REGION_TABLE_VALUES[key]["SOS"],
        REGION_TABLE_VALUES[key]["WRSI"],
        REGION_TABLE_VALUES[key]["LGP"],
        REGION_TABLE_VALUES[key]["WHC"],
        REGION_TABLE_VALUES[key]["SOSColor"])
    db_util.write_db(INSERT_SQL, params, config.EXAMPLE_DB_FILE)

print("database created")
