'''
/***************************************************************************
Name	   :  fews_tools_config.py
Description:  Configuration for FEWSTools plugin
copyright  :  (C) 2019-2023 by FEWS
email      :  minxuansun@contractor.usgs.gov
Modified   :  07/09/2020 - cholen - Added color file elements
              12/16/2020 - cholen - Dateformat info to dictionaries
              02/01/2021 - cholen - Comment NetCDF until external tool works
              06/25/2021 - cholen - Remove LUT
              02/22/2022 - cholen - Add tiff support, add FEWS date formats
              07/13/2022 - cholen - Add daily FEWS date format
              07/25/2022 - cholen - Add OLD_DB_FILE
              09/24/2025 - dhackman - Updating web documentation links
                  and local documentation files

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************
 '''
import os

# config for setting up workspace and folders
WORKSPACE = 'fews_tools_WS'
OLD_WORKSPACE = 'fews_tools_WS_old'
PROGRAM_SETTINGS = 'ProgramSettings'
DATA = 'Data'
STATIC = 'Static'
OUTPUT = 'Output'
MAPS = 'Maps'
CLIMATE = 'Climate'
COLORS = 'Colors'
ARCHIVES = 'archives'
TEMP = 'Temp'

OGR = 'ogr'
EHDR = 'EHdr'
GTIFF = 'GTiff'

DEFAULT_CRS = 'EPSG:4326'

OLD_DB_FILE = os.path.join(os.path.dirname(os.path.realpath(__file__)),
                           'geoclim.sqlite')

DB_FILE = os.path.join(os.path.dirname(os.path.realpath(__file__)),
                       'fews_tools.sqlite')

EXAMPLE_DB_FILE = os.path.join(os.path.dirname(os.path.realpath(__file__)),
                               'fews_tools_example.sqlite')

PERIODICITY_LIST = ['Dekadal', 'Monthly', 'Pentadal', 'Day']
PROJECTION_LIST = ['geographic']

DATA_TYPES = [['Rainfall', 'PPT'],
              ['Avg Temperature', 'TAV'],
              ['Min Temperature', 'TMN'],
              ['Max Temperature', 'TMX'],
              ['Evapotranspiration', 'PET']]


DATE_FORMATS_DIC = {
    'YYYYMMK': {'PERIODICITY': PERIODICITY_LIST[0],
                'PER_STRING': '4-digit year; 2-digit month; 1-digit dekad',
                'REG_EXPR': r'\d{7}'},
    'YYYYEK': {'PERIODICITY': PERIODICITY_LIST[0],
               'PER_STRING': '4-digit year; 2-digit dekad (01-36)',
               'REG_EXPR': r'\d{6}'},
    'YYMMK': {'PERIODICITY': PERIODICITY_LIST[0],
              'PER_STRING': '2-digit year; 2-digit month; 1-digit dekad',
              'REG_EXPR': r'\d{5}'},
    'YYEK': {'PERIODICITY': PERIODICITY_LIST[0],
             'PER_STRING': '2-digit year; 2-digit dekad (01-36)',
             'REG_EXPR': r'\d{4}'},
    'YYYYMMP': {'PERIODICITY': PERIODICITY_LIST[2],
                'PER_STRING': '4-digit year; 2-digit month; 1-digit pentad',
                'REG_EXPR': r'\d{7}'},
    'YYYYPT': {'PERIODICITY': PERIODICITY_LIST[2],
               'PER_STRING': '4-digit year; 2-digit pentad(01-72)',
               'REG_EXPR': r'\d{6}'},
    'YYMMP': {'PERIODICITY': PERIODICITY_LIST[2],
              'PER_STRING': '2-digit year; 2-digit month; 1-digit pentad',
              'REG_EXPR': r'\d{5}'},
    'YYPT': {'PERIODICITY': PERIODICITY_LIST[2],
             'PER_STRING': '2-digit year; 2-digit pentad (01-72)',
             'REG_EXPR': r'\d{4}'},
    'YYYYMM': {'PERIODICITY': PERIODICITY_LIST[1],
               'PER_STRING': '4-digit year; 2-digit month (01-12)',
               'REG_EXPR': r'\d{6}'},
    'YYMM': {'PERIODICITY': PERIODICITY_LIST[1],
             'PER_STRING': '2-digit year; 2-digit month (01-12)',
             'REG_EXPR': r'\d{4}'},
    'YYYYMMDD': {'PERIODICITY': PERIODICITY_LIST[3],
                 'PER_STRING':
                     '4-digit year; 2-digit month (01-12); 2-digit day',
                     'REG_EXPR': r'\d{8}'},
    'YYMMDD': {'PERIODICITY': PERIODICITY_LIST[3],
               'PER_STRING':
                   '2-digit year; 2-digit month (01-12); 2-digit day',
                   'REG_EXPR': r'\d{6}'},
    'YYYYJJJ': {'PERIODICITY': PERIODICITY_LIST[3],
                'PER_STRING': '4-digit year; 3-digit Julian day',
                'REG_EXPR': r'\d{7}'},
    'YYJJJ': {'PERIODICITY': PERIODICITY_LIST[3],
              'PER_STRING': '2-digit year; 3-digit Julian day',
              'REG_EXPR': r'\d{5}'},
    'YYYYJ': {'PERIODICITY': PERIODICITY_LIST[3],
              'PER_STRING': '4-digit year; 1-digit Julian day',
              'REG_EXPR': r'\d{5}'},
    'YYJ': {'PERIODICITY': PERIODICITY_LIST[3],
            'PER_STRING': '2-digit year; 1-digit Julian day',
            'REG_EXPR': r'\d{3}'},
    'YYYY.MM.P': {'PERIODICITY': PERIODICITY_LIST[2],
                  'PER_STRING': 'FEWS format YYYY.MM.P',
                  'REG_EXPR': r'(\d{4}[.]\d{2}[.]\d{1})'},
    'YYYY.MM.K': {'PERIODICITY': PERIODICITY_LIST[0],
                  'PER_STRING': 'FEWS format YYYY.MM.K',
                  'REG_EXPR': r'(\d{4}[.]\d{2}[.]\d{1})'},
    'YYYY.MM': {'PERIODICITY': PERIODICITY_LIST[1],
                'PER_STRING': 'FEWS format YYYY.MM',
                'REG_EXPR': r'(\d{4}[.]\d{2})'},
    'YYYY.MM.DD': {'PERIODICITY': PERIODICITY_LIST[3],
                   'PER_STRING': 'FEWS format YYYY.MM.DD',
                   'REG_EXPR': r'(\d{4}[.]\d{2}[.]\d{2})'}
                        }

AVG_DATE_FORMATS_DIC = {
    'MMK': {'PERIODICITY': PERIODICITY_LIST[0],
            'PER_STRING': '2-digit month; 1-digit dekad [Averages]',
            'REG_EXPR': r'\d{3}'},
    'EK': {'PERIODICITY': PERIODICITY_LIST[0],
           'PER_STRING': '2-digit dekad (01-36) [Averages]',
           'REG_EXPR': r'\d{2}'},
    'K': {'PERIODICITY': PERIODICITY_LIST[0],
          'PER_STRING': '1-or-2-digit dekad (1-36) [Averages]',
          'REG_EXPR': r'\d{1}'},
    'MMP': {'PERIODICITY': PERIODICITY_LIST[2],
            'PER_STRING': '2-digit month; 1-digit pentad [Averages]',
            'REG_EXPR': r'\d{3}'},
    'PT': {'PERIODICITY': PERIODICITY_LIST[2],
           'PER_STRING': '2-digit pentad (01-72) [Averages]',
           'REG_EXPR': r'\d{2}'},
    'P': {'PERIODICITY': PERIODICITY_LIST[2],
          'PER_STRING': '1-or-2-digit pentad (1-72) [Averages]',
          'REG_EXPR': r'\d{1}'},
    'MM': {'PERIODICITY': PERIODICITY_LIST[1],
           'PER_STRING': '2-digit month (01-12) [Averages]',
           'REG_EXPR': r'\d{2}'},
    'M': {'PERIODICITY': PERIODICITY_LIST[1],
          'PER_STRING': '1-digit month (1-12) [Averages]',
          'REG_EXPR': r'\d{1}'},
    'MMDD': {'PERIODICITY': PERIODICITY_LIST[3],
             'PER_STRING': '2-digit month (01-12); 2-digit day [Averages]',
             'REG_EXPR': r'\d{4}'},
    'JJJ': {'PERIODICITY': PERIODICITY_LIST[3],
            'PER_STRING': '3-digit Julian day [Averages]',
            'REG_EXPR': r'\d{3}'},
    'J': {'PERIODICITY': PERIODICITY_LIST[3],
          'PER_STRING': '1-digit Julian day [Averages]',
          'REG_EXPR': r'\d{1}'},
    'MM.P': {'PERIODICITY': PERIODICITY_LIST[2],
             'PER_STRING': 'FEWS format MM.P [Averages]',
             'REG_EXPR': r'(\d{2}[.]\d{1})'},
    'MM.K': {'PERIODICITY': PERIODICITY_LIST[0],
             'PER_STRING': 'FEWS format MM.K [Averages]',
             'REG_EXPR': r'(\d{2}[.]\d{1})'},
    'MM.DD': {'PERIODICITY': PERIODICITY_LIST[3],
              'PER_STRING': 'FEWS format MM.DD [Averages]',
              'REG_EXPR': r'(\d{2}[.]\d{2})'}
                        }

DATA_EXTENTS = ['Africa', 'Camer-Carib', 'Global']
DEFAULT_AFRICA_MASK = 'africa_chirps_mask.bil'
DEFAULT_CAMCAR_MASK = 'CentralAmerica.bil'
DEFAULT_GLOBAL_MASK = 'global_mask0_1.bil'

# color files
CONTOUR_100_COLOR_FILE = 'contours_100.qml'
CONTOUR_200_COLOR_FILE = 'contours_200.qml'
CONTOUR_300_COLOR_FILE = 'contours_300.qml'
COUNT_COLOR_FILE = 'count_mx45.qml'
MAP_COLOR_FILE = 'map_layer.qml'
SECOND_MAP_COLOR_FILE = 'secondary_map_layer.qml'
MASK_COLOR_FILE = 'mask.qml'
RF_600_RASTER_COLOR_FILE = 'rainfall_600_raster.qml'
RF_1000_RASTER_COLOR_FILE = 'rainfall_1000_raster.qml'
RF_2500_PTS_COLOR_FILE = 'rainfall_2500_points.qml'
RF_2500_RASTER_COLOR_FILE = 'rainfall_2500_raster.qml'
RF_ANOM_DIFF_COLOR_FILE = 'rainfall_anomaly_diff_raster.qml'
RF_ANOM_PCT_COLOR_FILE = 'rainfall_anomaly_percent_raster.qml'
RF_CV_COLOR_FILE = 'rainfall_CV.qml'
RF_FREQUENCY_COLOR_FILE = 'rainfall_frequency.qml'
RF_FREQUENCY_COUNT_COLOR_FILE = 'rainfall_frequency_count.qml'
RF_TREND_COLOR_FILE = 'rainfall_trend.qml'
RF_TREND_R2_COLOR_FILE = 'rainfall_trend_r2.qml'
SPI_COLOR_FILE = 'SPI.qml'
WRSI_COLOR_FILE = 'wrsi.qml'
SOS_ANOM_DEKAD_COLOR_FILE = 'sos_anom_dekads.qml'
SOS_ANOM_PENTAD_COLOR_FILE = 'sos_anom_pentads.qml'
WRSI_ANOM_COLOR_FILE = 'wrsi_anom.qml'
SWI_COLOR_FILE = 'soil_water.qml'
LGP_PHEN_COLOR_FILE = 'lgp_frac.qml'
TOTALS_COLOR_FILE = 'totals_testing.qml'
MAX_COLOR_FILE = 'max_water_testing.qml'

ARCHIVE_SUFFIX = '.climdata'
BIL_SUFFIX = '.bil'
BILAUXXML_SUFFIX = '.bil.aux.xml'
DBF_SUFFIX = '.dbf'
HDR_SUFFIX = '.hdr'
PRJ_SUFFIX = '.prj'
STX_SUFFIX = '.stx'
JPG_SUFFIX = '.jpg'
PNG_SUFFIX = '.png'
SHP_SUFFIX = '.shp'
SHX_SUFFIX = '.shx'
TAR_GZ_SUFFIX = '.tar.gz'
TIF_GZ_SUFFIX = '.tif.gz'
TIF_SUFFIX = '.tif'
TIFF_SUFFIX = '.tiff'
ZIP_SUFFIX = '.zip'

RST_FILE_TYPES = "BIL files (*.bil);;TIF files (*.tif);;TIFF files (*.tiff)"
VEC_FILE_TYPES = "Shapefiles (*.shp);;BNA map files (*.bna);;All files (*.*)"
CSV_FILE_TYPES = "CSVs (*.csv)"

BETA_FILENAME = 'beta'
ALPHA_FILENAME = 'alpha'
LUT_FILENAME = 'PercentileToZScoreTable.csv'
PROB_OF_RAIN_FILENAME = 'ProbOfRainLT_Raster'

VALID_RASTER_SUFFIXES = [BIL_SUFFIX, TIF_SUFFIX, TIFF_SUFFIX]
VALID_VECTOR_SUFFIXES = [SHP_SUFFIX]
VALID_ZIP_SUFFIXES = [TAR_GZ_SUFFIX, TIF_GZ_SUFFIX, ZIP_SUFFIX]

DEFAULT_NO_DATA = -9999
MASK_NO_DATA = 0

WILD = '*'
TO = '_to_'  # used for file naming
CR = '\n'

MONTH_2_NUM_DIC = {'Jan': {'PER_YEAR': '01', 'FEWS_FMT': '.01'},
                   'Feb': {'PER_YEAR': '02', 'FEWS_FMT': '.02'},
                   'Mar': {'PER_YEAR': '03', 'FEWS_FMT': '.03'},
                   'Apr': {'PER_YEAR': '04', 'FEWS_FMT': '.04'},
                   'May': {'PER_YEAR': '05', 'FEWS_FMT': '.05'},
                   'Jun': {'PER_YEAR': '06', 'FEWS_FMT': '.06'},
                   'Jul': {'PER_YEAR': '07', 'FEWS_FMT': '.07'},
                   'Aug': {'PER_YEAR': '08', 'FEWS_FMT': '.08'},
                   'Sep': {'PER_YEAR': '09', 'FEWS_FMT': '.09'},
                   'Oct': {'PER_YEAR': '10', 'FEWS_FMT': '.10'},
                   'Nov': {'PER_YEAR': '11', 'FEWS_FMT': '.11'},
                   'Dec': {'PER_YEAR': '12', 'FEWS_FMT': '.12'}}

DEKAD_2_NUM_DIC = {'Jan_Dek1': {'PER_YEAR': '01', 'MON_PER': '011', 'FEWS_FMT': '.01.1'},
                   'Jan_Dek2': {'PER_YEAR': '02', 'MON_PER': '012', 'FEWS_FMT': '.01.2'},
                   'Jan_Dek3': {'PER_YEAR': '03', 'MON_PER': '013', 'FEWS_FMT': '.01.3'},
                   'Feb_Dek1': {'PER_YEAR': '04', 'MON_PER': '021', 'FEWS_FMT': '.02.1'},
                   'Feb_Dek2': {'PER_YEAR': '05', 'MON_PER': '022', 'FEWS_FMT': '.02.2'},
                   'Feb_Dek3': {'PER_YEAR': '06', 'MON_PER': '023', 'FEWS_FMT': '.02.3'},
                   'Mar_Dek1': {'PER_YEAR': '07', 'MON_PER': '031', 'FEWS_FMT': '.03.1'},
                   'Mar_Dek2': {'PER_YEAR': '08', 'MON_PER': '032', 'FEWS_FMT': '.03.2'},
                   'Mar_Dek3': {'PER_YEAR': '09', 'MON_PER': '033', 'FEWS_FMT': '.03.3'},
                   'Apr_Dek1': {'PER_YEAR': '10', 'MON_PER': '041', 'FEWS_FMT': '.04.1'},
                   'Apr_Dek2': {'PER_YEAR': '11', 'MON_PER': '042', 'FEWS_FMT': '.04.2'},
                   'Apr_Dek3': {'PER_YEAR': '12', 'MON_PER': '043', 'FEWS_FMT': '.04.3'},
                   'May_Dek1': {'PER_YEAR': '13', 'MON_PER': '051', 'FEWS_FMT': '.05.1'},
                   'May_Dek2': {'PER_YEAR': '14', 'MON_PER': '052', 'FEWS_FMT': '.05.2'},
                   'May_Dek3': {'PER_YEAR': '15', 'MON_PER': '053', 'FEWS_FMT': '.05.3'},
                   'Jun_Dek1': {'PER_YEAR': '16', 'MON_PER': '061', 'FEWS_FMT': '.06.1'},
                   'Jun_Dek2': {'PER_YEAR': '17', 'MON_PER': '062', 'FEWS_FMT': '.06.2'},
                   'Jun_Dek3': {'PER_YEAR': '18', 'MON_PER': '063', 'FEWS_FMT': '.06.3'},
                   'Jul_Dek1': {'PER_YEAR': '19', 'MON_PER': '071', 'FEWS_FMT': '.07.1'},
                   'Jul_Dek2': {'PER_YEAR': '20', 'MON_PER': '072', 'FEWS_FMT': '.07.2'},
                   'Jul_Dek3': {'PER_YEAR': '21', 'MON_PER': '073', 'FEWS_FMT': '.07.3'},
                   'Aug_Dek1': {'PER_YEAR': '22', 'MON_PER': '081', 'FEWS_FMT': '.08.1'},
                   'Aug_Dek2': {'PER_YEAR': '23', 'MON_PER': '082', 'FEWS_FMT': '.08.2'},
                   'Aug_Dek3': {'PER_YEAR': '24', 'MON_PER': '083', 'FEWS_FMT': '.08.3'},
                   'Sep_Dek1': {'PER_YEAR': '25', 'MON_PER': '091', 'FEWS_FMT': '.09.1'},
                   'Sep_Dek2': {'PER_YEAR': '26', 'MON_PER': '092', 'FEWS_FMT': '.09.2'},
                   'Sep_Dek3': {'PER_YEAR': '27', 'MON_PER': '093', 'FEWS_FMT': '.09.3'},
                   'Oct_Dek1': {'PER_YEAR': '28', 'MON_PER': '101', 'FEWS_FMT': '.10.1'},
                   'Oct_Dek2': {'PER_YEAR': '29', 'MON_PER': '102', 'FEWS_FMT': '.10.2'},
                   'Oct_Dek3': {'PER_YEAR': '30', 'MON_PER': '103', 'FEWS_FMT': '.10.3'},
                   'Nov_Dek1': {'PER_YEAR': '31', 'MON_PER': '111', 'FEWS_FMT': '.11.1'},
                   'Nov_Dek2': {'PER_YEAR': '32', 'MON_PER': '112', 'FEWS_FMT': '.11.2'},
                   'Nov_Dek3': {'PER_YEAR': '33', 'MON_PER': '113', 'FEWS_FMT': '.11.3'},
                   'Dec_Dek1': {'PER_YEAR': '34', 'MON_PER': '121', 'FEWS_FMT': '.12.1'},
                   'Dec_Dek2': {'PER_YEAR': '35', 'MON_PER': '122', 'FEWS_FMT': '.12.2'},
                   'Dec_Dek3': {'PER_YEAR': '36', 'MON_PER': '123', 'FEWS_FMT': '.12.3'}}

PENTAD_2_NUM_DIC = {'Jan_Pen1': {'PER_YEAR': '01', 'MON_PER': '011', 'FEWS_FMT': '.01.1'},
                    'Jan_Pen2': {'PER_YEAR': '02', 'MON_PER': '012', 'FEWS_FMT': '.01.2'},
                    'Jan_Pen3': {'PER_YEAR': '03', 'MON_PER': '013', 'FEWS_FMT': '.01.3'},
                    'Jan_Pen4': {'PER_YEAR': '04', 'MON_PER': '014', 'FEWS_FMT': '.01.4'},
                    'Jan_Pen5': {'PER_YEAR': '05', 'MON_PER': '015', 'FEWS_FMT': '.01.5'},
                    'Jan_Pen6': {'PER_YEAR': '06', 'MON_PER': '016', 'FEWS_FMT': '.01.6'},
                    'Feb_Pen1': {'PER_YEAR': '07', 'MON_PER': '021', 'FEWS_FMT': '.02.1'},
                    'Feb_Pen2': {'PER_YEAR': '08', 'MON_PER': '022', 'FEWS_FMT': '.02.2'},
                    'Feb_Pen3': {'PER_YEAR': '09', 'MON_PER': '023', 'FEWS_FMT': '.02.3'},
                    'Feb_Pen4': {'PER_YEAR': '10', 'MON_PER': '024', 'FEWS_FMT': '.02.4'},
                    'Feb_Pen5': {'PER_YEAR': '11', 'MON_PER': '025', 'FEWS_FMT': '.02.5'},
                    'Feb_Pen6': {'PER_YEAR': '12', 'MON_PER': '026', 'FEWS_FMT': '.02.6'},
                    'Mar_Pen1': {'PER_YEAR': '13', 'MON_PER': '031', 'FEWS_FMT': '.03.1'},
                    'Mar_Pen2': {'PER_YEAR': '14', 'MON_PER': '032', 'FEWS_FMT': '.03.2'},
                    'Mar_Pen3': {'PER_YEAR': '15', 'MON_PER': '033', 'FEWS_FMT': '.03.3'},
                    'Mar_Pen4': {'PER_YEAR': '16', 'MON_PER': '034', 'FEWS_FMT': '.03.4'},
                    'Mar_Pen5': {'PER_YEAR': '17', 'MON_PER': '035', 'FEWS_FMT': '.03.5'},
                    'Mar_Pen6': {'PER_YEAR': '18', 'MON_PER': '036', 'FEWS_FMT': '.03.6'},
                    'Apr_Pen1': {'PER_YEAR': '19', 'MON_PER': '041', 'FEWS_FMT': '.04.1'},
                    'Apr_Pen2': {'PER_YEAR': '20', 'MON_PER': '042', 'FEWS_FMT': '.04.2'},
                    'Apr_Pen3': {'PER_YEAR': '21', 'MON_PER': '043', 'FEWS_FMT': '.04.3'},
                    'Apr_Pen4': {'PER_YEAR': '22', 'MON_PER': '044', 'FEWS_FMT': '.04.4'},
                    'Apr_Pen5': {'PER_YEAR': '23', 'MON_PER': '045', 'FEWS_FMT': '.04.5'},
                    'Apr_Pen6': {'PER_YEAR': '24', 'MON_PER': '046', 'FEWS_FMT': '.04.6'},
                    'May_Pen1': {'PER_YEAR': '25', 'MON_PER': '051', 'FEWS_FMT': '.05.1'},
                    'May_Pen2': {'PER_YEAR': '26', 'MON_PER': '052', 'FEWS_FMT': '.05.2'},
                    'May_Pen3': {'PER_YEAR': '27', 'MON_PER': '053', 'FEWS_FMT': '.05.3'},
                    'May_Pen4': {'PER_YEAR': '28', 'MON_PER': '054', 'FEWS_FMT': '.05.4'},
                    'May_Pen5': {'PER_YEAR': '29', 'MON_PER': '055', 'FEWS_FMT': '.05.5'},
                    'May_Pen6': {'PER_YEAR': '30', 'MON_PER': '056', 'FEWS_FMT': '.05.6'},
                    'Jun_Pen1': {'PER_YEAR': '31', 'MON_PER': '061', 'FEWS_FMT': '.06.1'},
                    'Jun_Pen2': {'PER_YEAR': '32', 'MON_PER': '062', 'FEWS_FMT': '.06.2'},
                    'Jun_Pen3': {'PER_YEAR': '33', 'MON_PER': '063', 'FEWS_FMT': '.06.3'},
                    'Jun_Pen4': {'PER_YEAR': '34', 'MON_PER': '064', 'FEWS_FMT': '.06.4'},
                    'Jun_Pen5': {'PER_YEAR': '35', 'MON_PER': '065', 'FEWS_FMT': '.06.5'},
                    'Jun_Pen6': {'PER_YEAR': '36', 'MON_PER': '066', 'FEWS_FMT': '.06.6'},
                    'Jul_Pen1': {'PER_YEAR': '37', 'MON_PER': '071', 'FEWS_FMT': '.07.1'},
                    'Jul_Pen2': {'PER_YEAR': '38', 'MON_PER': '072', 'FEWS_FMT': '.07.2'},
                    'Jul_Pen3': {'PER_YEAR': '39', 'MON_PER': '073', 'FEWS_FMT': '.07.3'},
                    'Jul_Pen4': {'PER_YEAR': '40', 'MON_PER': '074', 'FEWS_FMT': '.07.4'},
                    'Jul_Pen5': {'PER_YEAR': '41', 'MON_PER': '075', 'FEWS_FMT': '.07.5'},
                    'Jul_Pen6': {'PER_YEAR': '42', 'MON_PER': '076', 'FEWS_FMT': '.07.6'},
                    'Aug_Pen1': {'PER_YEAR': '43', 'MON_PER': '081', 'FEWS_FMT': '.08.1'},
                    'Aug_Pen2': {'PER_YEAR': '44', 'MON_PER': '082', 'FEWS_FMT': '.08.2'},
                    'Aug_Pen3': {'PER_YEAR': '45', 'MON_PER': '083', 'FEWS_FMT': '.08.3'},
                    'Aug_Pen4': {'PER_YEAR': '46', 'MON_PER': '084', 'FEWS_FMT': '.08.4'},
                    'Aug_Pen5': {'PER_YEAR': '47', 'MON_PER': '085', 'FEWS_FMT': '.08.5'},
                    'Aug_Pen6': {'PER_YEAR': '48', 'MON_PER': '086', 'FEWS_FMT': '.08.6'},
                    'Sep_Pen1': {'PER_YEAR': '49', 'MON_PER': '091', 'FEWS_FMT': '.09.1'},
                    'Sep_Pen2': {'PER_YEAR': '50', 'MON_PER': '092', 'FEWS_FMT': '.09.2'},
                    'Sep_Pen3': {'PER_YEAR': '51', 'MON_PER': '093', 'FEWS_FMT': '.09.3'},
                    'Sep_Pen4': {'PER_YEAR': '52', 'MON_PER': '094', 'FEWS_FMT': '.09.4'},
                    'Sep_Pen5': {'PER_YEAR': '53', 'MON_PER': '095', 'FEWS_FMT': '.09.5'},
                    'Sep_Pen6': {'PER_YEAR': '54', 'MON_PER': '096', 'FEWS_FMT': '.09.6'},
                    'Oct_Pen1': {'PER_YEAR': '55', 'MON_PER': '101', 'FEWS_FMT': '.10.1'},
                    'Oct_Pen2': {'PER_YEAR': '56', 'MON_PER': '102', 'FEWS_FMT': '.10.2'},
                    'Oct_Pen3': {'PER_YEAR': '57', 'MON_PER': '103', 'FEWS_FMT': '.10.3'},
                    'Oct_Pen4': {'PER_YEAR': '58', 'MON_PER': '104', 'FEWS_FMT': '.10.4'},
                    'Oct_Pen5': {'PER_YEAR': '59', 'MON_PER': '105', 'FEWS_FMT': '.10.5'},
                    'Oct_Pen6': {'PER_YEAR': '60', 'MON_PER': '106', 'FEWS_FMT': '.10.6'},
                    'Nov_Pen1': {'PER_YEAR': '61', 'MON_PER': '111', 'FEWS_FMT': '.11.1'},
                    'Nov_Pen2': {'PER_YEAR': '62', 'MON_PER': '112', 'FEWS_FMT': '.11.2'},
                    'Nov_Pen3': {'PER_YEAR': '63', 'MON_PER': '113', 'FEWS_FMT': '.11.3'},
                    'Nov_Pen4': {'PER_YEAR': '64', 'MON_PER': '114', 'FEWS_FMT': '.11.4'},
                    'Nov_Pen5': {'PER_YEAR': '65', 'MON_PER': '115', 'FEWS_FMT': '.11.5'},
                    'Nov_Pen6': {'PER_YEAR': '66', 'MON_PER': '116', 'FEWS_FMT': '.11.6'},
                    'Dec_Pen1': {'PER_YEAR': '67', 'MON_PER': '121', 'FEWS_FMT': '.12.1'},
                    'Dec_Pen2': {'PER_YEAR': '68', 'MON_PER': '122', 'FEWS_FMT': '.12.2'},
                    'Dec_Pen3': {'PER_YEAR': '69', 'MON_PER': '123', 'FEWS_FMT': '.12.3'},
                    'Dec_Pen4': {'PER_YEAR': '70', 'MON_PER': '124', 'FEWS_FMT': '.12.4'},
                    'Dec_Pen5': {'PER_YEAR': '71', 'MON_PER': '125', 'FEWS_FMT': '.12.5'},
                    'Dec_Pen6': {'PER_YEAR': '72', 'MON_PER': '126', 'FEWS_FMT': '.12.6'}}

# user input validatioin config elements
REG_EXPR_A = '^[A-Za-z0-9_-]*$'
REG_EXPR_B = '^[A-Za-z0-9_-]*$'   # TODO - VERIFY CHARS
REG_EXPR_COMMENTS = '^[ A-Za-z0-9_\\-\\(\\)]*$'
MAX_CHARS = 255

## NetCDF config elements
#NET_CDF_DIR = 'NetCDF'
#NET_CDF_EXE = 'netCDFconverterV2.exe'
#NET_CDF_TXT = 'exportfilesanddates.txt'

DEKAD_NOSTART = 60
PENTAD_NOSTART = 160

GEOWRSI_OUT_SETTINGS_FILE = 'geowrsi_output_settings.txt'
GEOWRSI_SETTINGS_FILE = 'geowrsi_settings.txt'
HISTORICAL = 'historical'
CURRENT = 'current'
MULTI_HISTORICAL = 'multi_historical'

DEKAD_SHIFT = 6
PENTAD_SHIFT = 12
DEKADS_PER_YEAR = 36
PENTADS_PER_YEAR = 72
NO_DATA = 255
YET_TO_START = 254
FAIL_NO_START = 253
SOS_YET_TO_START = 150

DOWNLOAD_RETRIES = 5

ENGLISH_MANUAL = os.path.join(os.path.abspath(__file__), "..", "static", "FEWS_Tools_User_Manual_3.3.0_English.pdf")
SPANISH_MANUAL = os.path.join(os.path.abspath(__file__), "..", "static", "FEWS_Tools_User_Manual_3.2.0_Spanish.pdf")
GEOCLIM_WEBPAGE_ENGLISH = "https://help.fews.net/en/tools/v2/geoclim-functions"
GEOCLIM_WEBPAGE_SPANISH = "https://help.fews.net/es/tools/v2/geoclim-functions"
GEOWRSI_WEBPAGE_ENGLISH = "https://help.fews.net/en/tools/v2/geowrsi-functions"
GEOWRSI_WEBPAGE_SPANISH = "https://help.fews.net/es/tools/v2/geowrsi-functions"
