'''
/***************************************************************************
Name	   :  select_region.py
Description:  Select region class for FEWSTools plugin,
              updated from QGIS2
copyright  :  (C) 2019 - 2023 by FEWS
email      :  minxuansun@contractor.usgs.gov
Modified   :  MM/DD/YYYY - <developer> - Description
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
'''

from PyQt5.QtWidgets import QDialog

from fews_tools.models.region_model import RegionModel
from fews_tools.forms.Ui_SelectRegion import Ui_SelectRegion


class SelectRegion(QDialog):
    '''
    Class for selecting a region
    '''
    def __init__(self):
        QDialog.__init__(self)
        self.ui = Ui_SelectRegion()
        self.ui.setupUi(self)
        self.region_name = ''
        self.ui.regionComboBox.setFocus()
        reg_info = RegionModel()
        self.ui.regionComboBox.currentIndexChanged['QString'].connect(
            self.set_region_name)
        self.ui.okButton.clicked.connect(self.get_region_name)
        # fill the combo box
        region_name_list = reg_info.get_all_region_names()
        for entry in region_name_list:
            self.ui.regionComboBox.addItem(entry)
        self.ui.regionComboBox.setCurrentIndex(0)

    def get_region_name(self):
        '''
        Get the widget value
        returns: region_name(string) - Region name
        '''
        self.close()
        return self.region_name

    def set_region_name(self):
        '''
        Set the widget value
        '''
        self.region_name = self.ui.regionComboBox.currentText()
