
"""
/***************************************************************************
Name            :  help_utilities.py
Description     :  A class for help icon
copyright       :  (C) 2019-2025 by FEWS
email           :  jhowton@contractor.usgs.gov
Created         :  04/15/2025 Jacob Howton
Modified        :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import webbrowser
import requests

from PyQt5.QtWidgets import QMessageBox

from fews_tools import fews_tools_config as config


def view_manual(section=None):
        """
        Function to check if a url for the manual works, if not prompt to open either the english or spanish manual
        """
        msg_box = QMessageBox()
        msg_box.setText("Which version of the manual would you like to open?")
        msg_box.setWindowTitle("Version Selection")

        button_english = msg_box.addButton("English", QMessageBox.AcceptRole)
        button_spanish = msg_box.addButton("Spanish", QMessageBox.AcceptRole)
        button_quit = msg_box.addButton("Quit", QMessageBox.AcceptRole)

        msg_box.exec_()

        if msg_box.clickedButton() == button_english:
            url = config.GEOCLIM_WEBPAGE_ENGLISH
        elif msg_box.clickedButton() == button_spanish:
            url = config.GEOCLIM_WEBPAGE_SPANISH
        elif msg_box.clickedButton() == button_quit:
            msg_box.close()
            return
        
        if section:
            url = url.replace('geoclim-functions', section)

        if check_website_exists(url):
            webbrowser.open(url)

        else:
            # Create a message box to explain the website is not working and prompt for local manual opening
            msg_box = QMessageBox()
            msg_box.setText("The website containing the online version of the manual is down, which local version would you like to open?")
            msg_box.setWindowTitle("Manual website error")

            button_english = msg_box.addButton("English", QMessageBox.AcceptRole)
            button_spanish = msg_box.addButton("Spanish", QMessageBox.AcceptRole)
            button_quit = msg_box.addButton("Quit", QMessageBox.AcceptRole)

            msg_box.exec_()

            if msg_box.clickedButton() == button_english:
                webbrowser.open(config.ENGLISH_MANUAL)
            elif msg_box.clickedButton() == button_spanish:
                webbrowser.open(config.SPANISH_MANUAL)
            elif msg_box.clickedButton() == button_quit:
                msg_box.close()

def view_manual_wrsi(section=None):
        """
        Function to check if a url for the manual works, if not prompt to open the english
        """
        msg_box = QMessageBox()
        msg_box.setText("Which version of the manual would you like to open?")
        msg_box.setWindowTitle("Version Selection")

        button_english = msg_box.addButton("English", QMessageBox.AcceptRole)
        button_spanish = msg_box.addButton("Spanish", QMessageBox.AcceptRole)
        button_quit = msg_box.addButton("Quit", QMessageBox.AcceptRole)

        msg_box.exec_()

        if msg_box.clickedButton() == button_english:
            url = config.GEOWRSI_WEBPAGE_ENGLISH
        elif msg_box.clickedButton() == button_spanish:
            url = config.GEOWRSI_WEBPAGE_SPANISH
        elif msg_box.clickedButton() == button_quit:
            msg_box.close()
            return
        
        if section:
            url = url.replace('geowrsi-functions', section)

        if check_website_exists(url):
            webbrowser.open(url)

        else:
            # Create a message box to explain the website is not working and prompt for local manual opening
            msg_box = QMessageBox()
            msg_box.setText("The website containing the online version of the manual is down, which local version would you like to open?")
            msg_box.setWindowTitle("Manual website error")

            button_english = msg_box.addButton("English", QMessageBox.AcceptRole)
            button_spanish = msg_box.addButton("Spanish", QMessageBox.AcceptRole)
            button_quit = msg_box.addButton("Quit", QMessageBox.AcceptRole)

            msg_box.exec_()

            if msg_box.clickedButton() == button_english:
                webbrowser.open(config.ENGLISH_MANUAL)
            elif msg_box.clickedButton() == button_spanish:
                webbrowser.open(config.SPANISH_MANUAL)
            elif msg_box.clickedButton() == button_quit:
                msg_box.close()

def check_website_exists(url):
    """
    Check if the given url responds ok or if it is down
    """
    try:
        response = requests.head(url)
        print("response: " + str(response))
        return response.status_code == 200
    except requests.ConnectionError:
        return False
